package com.ejie.ab04b.service;

import com.ejie.ab04b.exception.AB04BException;
import com.ejie.foldermanagement.xml.ContextSubmissionEvent;

/**
 * 
 * @author GFI-NORTE
 * 
 */
public interface ConsolidarEventoService {

	/**
	 * Consolidar evento sol telematica OS 2.
	 * 
	 *  contextSubmission
	 *            ContextSubmissionEvent
	 *  idTramite
	 *            Long
	 *
	 * @param contextSubmission the context submission
	 * @param idTramite the id tramite
	 * @throws AB04BException the AB 04 B exception
	 */
	void consolidarEventoSolTelematicaOS2(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException;

	/**
	 * Consolidar evento sol telematica apertura.
	 * 
	 *  contextSubmission
	 *            ContextSubmissionEvent
	 *  idTramite
	 *            Long
	 *
	 * @param contextSubmission the context submission
	 * @param idTramite the id tramite
	 * @throws AB04BException the AB 04 B exception
	 */
	void consolidarEventoSolTelematicaApertura(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException;

	/**
	 * Consolidar evento sol telematica OS 3.
	 * 
	 *  contextSubmission
	 *            ContextSubmissionEvent
	 *  idTramite
	 *            Long
	 *
	 * @param contextSubmission the context submission
	 * @param idTramite the id tramite
	 * @throws AB04BException the AB 04 B exception
	 */
	void consolidarEventoSolTelematicaOS3(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException;

	/**
	 * Consolidar evento sol presencial apertura.
	 * 
	 *  contextSubmission
	 *            ContextSubmissionEvent
	 *  idTramite
	 *            Long
	 *
	 * @param contextSubmission the context submission
	 * @param idTramite the id tramite
	 * @throws AB04BException the AB 04 B exception
	 */
	void consolidarEventoSolPresencialApertura(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException;

	/**
	 * Consolidar evento sol presencial OS 2.
	 * 
	 *  contextSubmission
	 *            ContextSubmissionEvent
	 *  idTramite
	 *            Long
	 *
	 * @param contextSubmission the context submission
	 * @param idTramite the id tramite
	 * @throws AB04BException the AB 04 B exception
	 */
	void consolidarEventoSolPresencialOS2(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException;

	/**
	 * Consolidar evento sol presencial OS 3.
	 * 
	 *  contextSubmission
	 *            ContextSubmissionEvent
	 *  idTramite
	 *            Long
	 *
	 * @param contextSubmission the context submission
	 * @param idTramite the id tramite
	 * @throws AB04BException the AB 04 B exception
	 */
	void consolidarEventoSolPresencialOS3(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException;
}
